#include <stdio.h>
#include <string.h>

#define MAX_STUDENTS 20

struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

void displayStudentDetails(struct Student students[], int numStudents, int id) {
    int i;
    for (i = 0; i < numStudents; i++) {
        if (students[i].id == id) {
            printf("ID: %d\n", students[i].id);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            return;
        }
    }
    printf("Student with ID %d not found.\n", id);
}

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents, i, searchId;

    printf("Enter the number of students (up to %d): ", MAX_STUDENTS);
    scanf("%d", &numStudents);

    if (numStudents > MAX_STUDENTS || numStudents <= 0) {
        printf("Invalid number of students.\n");
        return 1;
    }
    for (i = 0; i < numStudents; i++) {
        printf("\nEnter details for student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);
        printf("Name: ");
        scanf("%s", students[i].name);
        printf("Age (between 18 and 24): ");
        scanf("%d", &students[i].age);
        if (students[i].age < 18 || students[i].age > 24) {
            printf("Invalid age. Please enter again: ");
            scanf("%d", &students[i].age);
        }
        printf("Address: ");
        scanf("%s", students[i].address);
    }
    printf("\nEnter the ID of the student to search: ");
    scanf("%d", &searchId);
    displayStudentDetails(students, numStudents, searchId);

    return 0;
}

